--***********************************************************
--**                    ShadowCop		                   **
--***********************************************************

require "TimedActions/ISBaseTimedAction"

ISFuelChainsawAction = ISBaseTimedAction:derive("ISFuelChainsawAction");

function ISFuelChainsawAction:isValid()
	return self.chainsaw ~= nil and self.petrol ~= nil and getPlayer():getPrimaryHandItem():getType() == "Chainsaw"
end

function ISFuelChainsawAction:update()
	self.chainsaw:setJobDelta(self:getJobDelta());
end

function ISFuelChainsawAction:start()
	self.chainsaw:setJobType(getText("ContextMenu_ChainsawFuel"));
	self.chainsaw:setJobDelta(0.0);
end

function ISFuelChainsawAction:stop()
	ISBaseTimedAction.stop(self);
    self.chainsaw:setJobDelta(0.0);
end

function ISFuelChainsawAction:perform()
	self.petrol:Use();
	self.ModData = self.chainsaw:getModData();
	self.ModData.FuelAmt = self.ModData.FuelAmt + 30;
	if(self.chainsaw:getModData().FuelAmt > 120) then
		self.chainsaw:getModData().FuelAmt = 120;
	end		
	self.chainsaw:setJobDelta(0.0);
	
	if self.full and self.chainsaw:getModData().FuelAmt < 120 and self.petrol:getUsedDelta() > 0 then
		ISTimedActionQueue.add(ISFuelChainsawAction:new(self.character, self.chainsaw, self.petrol, self.full, 50));
	end	
	
    -- needed to remove from queue / start next
	ISBaseTimedAction.perform(self);
end

function ISFuelChainsawAction:new(character, chainsaw, petrolcan, full, time)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o.character = character;
	o.stopOnWalk = true;
	o.stopOnRun = true;
	o.maxTime = time;
	-- custom fields
	o.chainsaw = chainsaw;
	o.petrol = petrolcan;
	o.full = full;
	o.ModData = nil
	return o;
end